/*************************************************
* SAFER-SK128 Header File                        *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SAFER_SK128_H__
#define OPENCL_SAFER_SK128_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SAFER_SK128 : public BlockCipher
   {
   public:
      static std::string name() { return "SAFER-SK128"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 16;
      static const u32bit DEFAULT_ROUNDS = 10, MAX_ROUNDS = 13;
      BlockCipher* clone() const { return new SAFER_SK128(ROUNDS); }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw();
      SAFER_SK128(u32bit = DEFAULT_ROUNDS);
   private:
      static const byte EXP[256], LOG[512], BIAS[208], KEY_INDEX[208];
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<byte, 256> SE[104], SD[104];
      SecureBuffer<byte, 8> MK;
      const u32bit ROUNDS;
   };

}

#endif
