/*************************************************
* TEA Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_TEA_H__
#define OPENCL_TEA_H__

#include <opencl/opencl.h>

namespace OpenCL {

class TEA : public BlockCipher
   {
   public:
      static std::string name() { return "TEA"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 16;
      BlockCipher* clone() const { return new TEA; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { K.clear(); }
      TEA() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      static const u32bit ROUNDS = 32, DELTA = 0x9E3779B9;
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<u32bit, 4> K;
   };

}

#endif
