/*************************************************
* ThreeWay Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_THREEWAY_H__
#define OPENCL_THREEWAY_H__

#include <opencl/opencl.h>

namespace OpenCL {

class ThreeWay : public BlockCipher
   {
   public:
      static std::string name() { return "ThreeWay"; }
      static const u32bit BLOCKSIZE = 12, KEYLENGTH = 12;
      BlockCipher* clone() const { return new ThreeWay; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { EK.clear(); DK.clear(); }
      ThreeWay() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      static void mu(u32bit&, u32bit&, u32bit&);
      static void theta(u32bit&, u32bit&, u32bit&);
      static void pi_gamma_pi(u32bit&, u32bit&, u32bit&);
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<u32bit, 36> EK, DK;
   };

}

#endif
