/*************************************************
* Memory Mapping Allocator Header File           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_MMAP_ALLOCATOR_H__
#define OPENCL_EXT_MMAP_ALLOCATOR_H__

#include <opencl/manalloc.h>
#include <opencl/mutex.h>
#include <utility>
#include <vector>
#include <map>

namespace OpenCL {

/*************************************************
* Memory Mapping Allocator                       *
*************************************************/
class MemoryMapping_Allocator : public ManagedAllocator
   {
   public:
      void* alloc_block(u32bit) const;
      void dealloc_block(void*, u32bit) const;
      SecureAllocator* clone() { return this; }
      MemoryMapping_Allocator(const std::string& = "");
      ~MemoryMapping_Allocator();
   private:
      static const u32bit CACHE_SIZE = 5;
      struct Maped_Buffer { void* buf; u32bit length; int fd; };

      u32bit getpagesize() const;
      bool is_suid() const;
      std::string temp_dir(const std::string&) const;
      void* mmap_block(u32bit) const;
      void munmap_block(void*, u32bit, u32bit) const;

      std::string path;
      mutable std::map<void*, std::pair<int, u32bit> > allocated;
      mutable std::vector<Maped_Buffer> cache;
      mutable Mutex* lock;
   };

}

#endif
