/*************************************************
* Zlib Compressor Header File                    *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_ZLIB_H__
#define OPENCL_EXT_ZLIB_H__

#include <opencl/filter.h>

namespace OpenCL {

class Zlib_Compress : public Filter
   {
   public:
      void write(const byte input[], u32bit length);
      void start_msg();
      void end_msg();

      void flush();

      Zlib_Compress(u32bit l = 9) : level((l >= 9) ? 9 : l) { zlib = 0; }
      ~Zlib_Compress() { clear(); }
   private:
      static const u32bit BUFFERSIZE = DEFAULT_BUFFERSIZE;
      void clear();
      const u32bit level;
      SecureBuffer<byte, BUFFERSIZE> buffer;
      struct zlib_stream_wrapper* zlib;
   };

class Zlib_Decompress : public Filter
   {
   public:
      void write(const byte input[], u32bit length);
      void start_msg();
      void end_msg();

      Zlib_Decompress() { zlib = 0; no_writes = true; }
      ~Zlib_Decompress() { clear(); }
   private:
      static const u32bit BUFFERSIZE = DEFAULT_BUFFERSIZE;
      void clear();
      SecureBuffer<byte, BUFFERSIZE> buffer;
      struct zlib_stream_wrapper* zlib;
      bool no_writes;
   };

}

#endif
