/*************************************************
* EGD EntropySource Source File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/es_egd.h>
#include <cstring>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

namespace OpenCL {

/*************************************************
* Gather Entropy from EGD                        *
*************************************************/
u32bit EGD_EntropySource::slow_poll(byte output[], u32bit length)
   {
   if(length > 255) length = 255;

   sockaddr_un addr;
   std::memset(&addr, 0, sizeof(addr));
   addr.sun_family = AF_UNIX;

   if(sizeof(addr.sun_path) < path.length() + 1)
      throw Exception("EGD_EntropySource: Socket path is too long");
   std::strcpy(addr.sun_path, path.c_str());

   int fd = socket(AF_UNIX, SOCK_STREAM, 0);
   if(fd == -1) return 0;

   socklen_t len = sizeof(addr.sun_family) + std::strlen(addr.sun_path) + 1;
   if(connect(fd, (struct sockaddr*)&addr, len))
      { close(fd); return 0; }

   byte buffer[2];
   buffer[0] = 1;
   buffer[1] = (byte)length;

   if(write(fd, buffer, 2) != 2) { close(fd); return 0; }
   if(read(fd, buffer, 1) != 1)  { close(fd); return 0; }

   ssize_t count = read(fd, output, buffer[0]);
   if(count == -1) { close(fd); return 0; }

   return count;
   }

}
