/*************************************************
* Unix EntropySource Header File                 *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_ENTROPY_SRC_UNIX_POPEN_H__
#define OPENCL_EXT_ENTROPY_SRC_UNIX_POPEN_H__

#include <opencl/opencl.h>
#include <vector>
#include <map>

namespace OpenCL {

struct Source
   {
   Source(const std::string& n, const std::string a, u32bit p)
      { name = n; args = a; priority = p; working = true; }
   Source(const std::string& n, u32bit p)
      { name = n; priority = p; working = true; }
   std::string name, args;
   u32bit priority;
   bool working;
   };

class Unix_EntropySource : public EntropySource
   {
   public:
      u32bit fast_poll(byte[], u32bit);
      u32bit slow_poll(byte[], u32bit);

      void add_sources(const Source[], u32bit);

      Unix_EntropySource(bool = true);
      Unix_EntropySource(const Source[], u32bit, bool = true);
   private:
      static const u32bit BUFFERSIZE = 256;
      static const Source DEFAULT_SOURCES[];
      void add_default_sources();
      u32bit gather(byte[], u32bit, u32bit);
      u32bit gather_entropy(Source&);
      void timestamp();
      SecureBuffer<byte, BUFFERSIZE> buffer;
      std::vector<Source> sources;
      u32bit position;
   };

}

#endif
