/*************************************************
* POSIX Thread Mutex Source File                 *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/mux_pthr.h>
#include <opencl/exceptn.h>
#include <pthread.h>

namespace OpenCL {

/*************************************************
* Wrapper Type for POSIX Thread Mutex            *
*************************************************/
struct mutex_wrapper
   {
   pthread_mutex_t mutex;
   };

/*************************************************
* Constructor                                    *
*************************************************/
Pthread_Mutex::Pthread_Mutex()
   {
   mutex = new mutex_wrapper;
   pthread_mutex_init(&(mutex->mutex), 0);
   }

/*************************************************
* Destructor                                     *
*************************************************/
Pthread_Mutex::~Pthread_Mutex()
   {
   if(pthread_mutex_destroy(&(mutex->mutex)))
      throw Exception("~Pthread_Mutex: mutex is locked in destructor");
   }

/*************************************************
* Lock the Mutex                                 *
*************************************************/
void Pthread_Mutex::lock()
   {
   if(pthread_mutex_lock(&(mutex->mutex)))
      throw Exception("Pthread_Mutex::lock: Error occured");
   }

/*************************************************
* Attempt Lock of Mutex                          *
*************************************************/
bool Pthread_Mutex::trylock()
   {
   if(pthread_mutex_trylock(&(mutex->mutex)))
      return false;
   return true;
   }

/*************************************************
* Unlock the Mutex                               *
*************************************************/
void Pthread_Mutex::unlock()
   {
   if(pthread_mutex_unlock(&(mutex->mutex)))
      throw Exception("Pthread_Mutex::unlock: Error occured");
   }

}
