/*************************************************
* Barrett Reducer Source File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/barrett.h>
#include <opencl/numthry.h>

namespace OpenCL {

/*************************************************
* Precompute values                              *
*************************************************/
BarrettReducer::BarrettReducer(const BigInt& n) : ModularReducer(n)
   {
   k = modulus.sig_words();
   mu.set_bit(32 * 2 * k);
   mu /= modulus;
   max_bits = 32 * 2 * k;
   b_to_k1.set_bit(32 * (k+1));
   }

/*************************************************
* Compute a remainder mod modulus                *
*************************************************/
BigInt BarrettReducer::reduce(const BigInt& n) const
   {
   if(n.bits() > max_bits) return (n % modulus);

   q2 = (n >> (32 * (k - 1))) * mu;
   q2.set_sign(Positive);
   q3 = (q2 >> (32 * (k + 1)));

   r1 = n;
   r1.set_sign(Positive);
   for(u32bit j = k + 1; j < r1.size(); j++) r1[j] = 0;
   r2 = q3 * modulus;
   for(u32bit j = k + 1; j < r2.size(); j++) r2[j] = 0;

   r1 -= r2;
   if(r1.is_negative()) r1 += b_to_k1;

   while(r1 >= modulus)
      r1 -= modulus;

   if(n.is_negative() && r1.is_nonzero()) { r1 = modulus - r1; }
   return r1;
   }

}
