/*************************************************
* ECB Mode Source File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/ecb.h>

namespace OpenCL {

/*************************************************
* ECB Encryption Constructor                     *
*************************************************/
ECB::ECB(BlockCipher* c, const BlockCipherKey& key, const std::string& n,
         u32bit size) :
   BlockCipherMode(c, n, key, BlockCipherModeIV(), size, size, 0)
   {
   }

/*************************************************
* Encrypt in ECB mode                            *
*************************************************/
void ECB::write(const byte input[], u32bit length)
   {
   buffer.copy(position, input, length);
   if(position + length >= BLOCKSIZE)
      {
      do_block(buffer, buffer);
      send(buffer, BLOCKSIZE);
      input += (BLOCKSIZE - position);
      length -= (BLOCKSIZE - position);
      while(length >= BLOCKSIZE)
         {
         do_block(input, buffer);
         send(buffer, BLOCKSIZE);
         input += BLOCKSIZE;
         length -= BLOCKSIZE;
         }
      buffer.copy(input, length);
      position = 0;
      }
   position += length;
   }

/*************************************************
* Finish encrypting in ECB mode                  *
*************************************************/
void ECB::end_msg()
   {
   if(position)
      throw Exception(name() + ": input was not in full blocks");
   }

}
