/*************************************************
* Exceptions Source File                         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/exceptn.h>
#include <opencl/util.h>

namespace OpenCL {

/*************************************************
* Constructor for Invalid_Key_Length             *
*************************************************/
Invalid_Key_Length::Invalid_Key_Length(const std::string& name, u32bit length)
   {
   set_msg(name + " cannot accept a key of length " + to_string(length));
   }

/*************************************************
* Constructor for Invalid_Block_Size             *
*************************************************/
Invalid_Block_Size::Invalid_Block_Size(const std::string& mode,
                                       const std::string& pad)
   {
   set_msg("Padding method " + pad + " cannot be used with " + mode);
   }

/*************************************************
* Constructor for Invalid_IV_Length              *
*************************************************/
Invalid_IV_Length::Invalid_IV_Length(const std::string& mode, u32bit bad_len)
   {
   set_msg("IV length " + to_string(bad_len) + " is invalid for " + mode);
   }

/*************************************************
* Constructor for Input_Too_Large                *
*************************************************/
Input_Too_Large::Input_Too_Large(const std::string& where,
                                 u32bit size, u32bit max)
   {
   set_msg("PK maximum input length of " + to_string(max) + " exceeded by "
           + to_string(size) + " in " + where);
   }

}
