/*************************************************
* Block Cipher Mode Base Source File             *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/modebase.h>

namespace OpenCL {

/*************************************************
* Block Cipher Mode Constructor                  *
*************************************************/
BlockCipherMode::BlockCipherMode(BlockCipher* c, const std::string& name,
                                 const BlockCipherKey& key,
                                 const BlockCipherModeIV& iv,
                                 u32bit blk_size) :
   BLOCKSIZE(blk_size), BUFFERSIZE(blk_size), IVSIZE(blk_size), mode_name(name)
   {
   init(c, key, iv);
   }

/*************************************************
* Block Cipher Mode Constructor                  *
*************************************************/
BlockCipherMode::BlockCipherMode(BlockCipher* c, const std::string& name,
                                 const BlockCipherKey& key,
                                 const BlockCipherModeIV& iv, u32bit blk_size,
                                 u32bit buf_size) :
   BLOCKSIZE(blk_size), BUFFERSIZE(buf_size), IVSIZE(blk_size), mode_name(name)
   {
   init(c, key, iv);
   }

/*************************************************
* Block Cipher Mode Constructor                  *
*************************************************/
BlockCipherMode::BlockCipherMode(BlockCipher* c, const std::string& name,
                                 const BlockCipherKey& key,
                                 const BlockCipherModeIV& iv, u32bit blk_size,
                                 u32bit buf_size, u32bit iv_size) :
   BLOCKSIZE(blk_size), BUFFERSIZE(buf_size), IVSIZE(iv_size), mode_name(name)
   {
   init(c, key, iv);
   }

/*************************************************
* Initialized the mode                           *
*************************************************/
void BlockCipherMode::init(BlockCipher* c, const BlockCipherKey& key,
                           const BlockCipherModeIV& iv)
   {
   cipher = c;
   buffer.resize(BUFFERSIZE);
   state.resize(IVSIZE);
   cipher->set_key(key, key.length());
   reset_iv(iv);
   position = 0;
   }

/*************************************************
* Reset the IV                                   *
*************************************************/
void BlockCipherMode::reset_iv(const BlockCipherModeIV& new_iv)
   {
   if(new_iv.length() != state.size())
      throw Invalid_IV_Length(name(), new_iv.length());
   state.copy(new_iv, new_iv.length());
   buffer.clear();
   position = 0;
   }

}
