/*************************************************
* Mutex Factory Source File                      *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/mutex.h>

namespace OpenCL {

namespace {

Mutex* mutex_factory = 0;

}

/*************************************************
* Get a Mutex                                    *
*************************************************/
Mutex* get_mutex()
   {
   if(mutex_factory == 0) mutex_factory = new Default_Mutex;
   return mutex_factory->clone();
   }

/*************************************************
* Release a Mutex                                *
*************************************************/
void release_mutex(Mutex* mutex)
   {
   delete mutex;
   }

/*************************************************
* Set the Mutex type                             *
*************************************************/
void set_mutex_type(Mutex* mutex)
   {
   delete mutex_factory;
   mutex_factory = mutex;
   }

}
