/*************************************************
* OpenPGP S2K Source File                        *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/pgp_s2k.h>

namespace OpenCL {

/*************************************************
* Derive a key using the OpenPGP S2K algorithm   *
*************************************************/
SymmetricKey OpenPGP_S2K::derive(const std::string& pw, u32bit keylen) const
   {
   static const byte ZERO_BYTE[1] = { 0 };
   SecureVector<byte> key(keylen), hash_buf(hash->out_length());

   u32bit pass = 0, generated = 0, total_size = pw.size() + salt.size();
   u32bit to_hash = std::max(iterations(), total_size);

   hash->clear();
   while(keylen > generated)
      {
      for(u32bit j = 0; j != pass; j++)
         hash->update(ZERO_BYTE, 1);

      u32bit left = to_hash;
      while(left >= total_size)
         {
         hash->update(salt, salt.size());
         hash->update(pw);
         left -= total_size;
         }
      if(left <= salt.size())
         hash->update(salt, left);
      else
         {
         hash->update(salt, salt.size());
         left -= salt.size();
         hash->update((const byte*)pw.c_str(), left);
         }

      hash->final(hash_buf);
      key.copy(generated, hash_buf, hash->out_length());
      generated += hash->out_length();
      pass++;
      }
   return SymmetricKey(key, key.size());
   }

/*************************************************
* OpenPGP S2K Constructor                        *
*************************************************/
OpenPGP_S2K::OpenPGP_S2K(HashFunction* h, u32bit i) : S2K(true)
   {
   hash = h;
   set_iterations(i);
   }

}
