/*************************************************
* Raw PK Padding Source File                     *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/pk_raw.h>

namespace OpenCL {

/*************************************************
* Pad                                            *
*************************************************/
SecureVector<byte> PK_NoPadding::pad(const byte in[], u32bit ilen,
                                     u32bit olen) const
   {
   if(ilen > olen)
      throw Exception("PK_NoPadding: Input is too large");

   return SecureVector<byte>(in, ilen);
   }

/*************************************************
* Unpad                                          *
*************************************************/
SecureVector<byte> PK_NoPadding::unpad(const byte in[], u32bit len) const
   {
   return SecureVector<byte>(in, len);
   }

}
