/*************************************************
* Timestamp Functions Source File                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/timers.h>
#include <opencl/tm_def.h>
#include <ctime>

namespace OpenCL {

namespace {

Timer* global_timer = 0;

}

/*************************************************
* Timer Access Functions                         *
*************************************************/
u64bit system_time()
   {
   return std::time(0);
   }

u64bit system_clock()
   {
   if(!global_timer) global_timer = new Default_Timer;
   return global_timer->clock();
   }

/*************************************************
* Set the Timer type                             *
*************************************************/
void set_timer_type(Timer* timer)
   {
   delete global_timer;
   global_timer = timer;
   }

}
