/* public domain */
#include <iostream>
#include <vector>
#include <string>

#include <opencl/encoder.h>
using namespace OpenCL_types;

/* Strip comments, whitespace, etc */
void strip(std::string& line)
   {
   if(line.find('#') != std::string::npos)
      line = line.erase(line.find('#'), std::string::npos);

   while(line.find(' ') != std::string::npos)
      line = line.erase(line.find(' '), 1);

   while(line.find('\t') != std::string::npos)
      line = line.erase(line.find('\t'), 1);
   }

byte* decode_hex(const std::string& in)
   {
   OpenCL::Pipe pipe(new OpenCL::HexDecoder);
   pipe.start_msg();
   pipe.write(in);
   pipe.end_msg();

   u32bit expected = pipe.remaining();
   byte* out = new byte[expected];
   u32bit retval = pipe.read(out, expected);

   if(retval != expected)
      {
      std::cout << "Error in decode_hex" << std::endl;
      std::exit(1);
      }
   return out;
   }

std::vector<std::string> parse(const std::string& line)
   {
   const char DELIMITER = ':';
   std::vector<std::string> substr;
   std::string::size_type start = 0, end = line.find(DELIMITER);
   while(end != std::string::npos)
      {
      substr.push_back(line.substr(start, end-start));
      start = end+1;
      end = line.find(DELIMITER, start);
      }
   if(line.size() > start)
      substr.push_back(line.substr(start));
   while(substr.size() <= 4) // at least 4 substr, some possibly empty
      substr.push_back("");
   return substr;
   }

