/*
Identical to hasher.cpp, but uses Pipe in a different way.

Written by Jack Lloyd (lloyd@acm.jhu.edu), Feb 8 2001

This file is in the public domain
*/
#include <fstream>
#include <iostream>
#include <string>
#include <opencl/filters.h>
#include <opencl/md5.h>
#include <opencl/sha1.h>
#include <opencl/rmd160.h>
#include <opencl/encoder.h>

int main(int argc, char* argv[])
   {
   if(argc < 2)
      {
      std::cout << "Usage: hasher2 <filenames>" << std::endl;
      return 1;
      }

   OpenCL::LibraryInitializer init;

   const int COUNT = 3;
   std::string name[COUNT] = { "MD5", "SHA-1", "RIPEMD-160" };

   OpenCL::Pipe pipe;

   for(int j = 1; argv[j] != 0; j++)
      {
      OpenCL::Filter* hash[COUNT] = {
         new OpenCL::HashFilter<OpenCL::MD5>,
         new OpenCL::HashFilter<OpenCL::SHA1>,
         new OpenCL::HashFilter<OpenCL::RIPEMD_160>
      };

      std::ifstream file(argv[j]);
      if(!file)
         {
         std::cout << "ERROR: could not open " << argv[j] << std::endl;
         continue;
         }
      for(int k = 0; k != COUNT; k++)
         {
         pipe.reset();
         pipe.append(hash[k]);
         pipe.append(new OpenCL::HexEncoder);
         pipe.start_msg();

         // trickiness: the >> op reads until EOF, but seekg won't work
         // unless we're in the "good" state (which EOF is not).
         file.clear();
         file.seekg(0, std::ios_base::beg);
         file >> pipe;
         pipe.end_msg();
         }
      file.close();
      for(int k = 0; k != COUNT; k++)
         {
         std::string out = pipe.read_all_as_string(COUNT * (j-1) + k);
         std::cout << name[k] << "(" << argv[j] << ") = " << out << std::endl;
         }
      }

   return 0;
   }
