/*
An OpenCL example application showing how to use the pop and prepend functions
of Pipe. Based on the md5 example. It's output should always be identical to
such.

Written by Jack Lloyd (lloyd@acm.jhu.edu), Feb 3, 2002

This file is in the public domain */

#include <iostream>
#include <fstream>
#include <opencl/filters.h>
#include <opencl/md5.h>
#include <opencl/sha1.h>
#include <opencl/rmd160.h>
#include <opencl/encoder.h>
#include <opencl/filters.h>

int main(int argc, char* argv[])
   {
   if(argc < 2)
      {
      std::cout << "Usage: stack <filenames>" << std::endl;
      return 1;
      }

   OpenCL::LibraryInitializer init;

   OpenCL::Pipe pipe;

   // this is a pretty vacuous example, but it's useful as a test
   pipe.prepend(new OpenCL::HashFilter<OpenCL::MD5>);
   pipe.prepend(new OpenCL::HashFilter<OpenCL::RIPEMD_160>);
   pipe.prepend(new OpenCL::Chain(new OpenCL::HashFilter<OpenCL::RIPEMD_160>,
                                  new OpenCL::HashFilter<OpenCL::RIPEMD_160>));
   pipe.pop(); // will pop everything inside the Chain as well as Chain itself
   pipe.pop();
   pipe.prepend(new OpenCL::HashFilter<OpenCL::SHA1>);
   pipe.attach(new OpenCL::HexEncoder);
   pipe.prepend(new OpenCL::HashFilter<OpenCL::SHA1>);
   pipe.pop();
   pipe.pop();
   pipe.prepend(new OpenCL::HashFilter<OpenCL::RIPEMD_160>);
   pipe.pop();

   for(int j = 1; argv[j] != 0; j++)
      {
      std::ifstream file(argv[j]);
      if(!file)
         {
         std::cout << "ERROR: could not open " << argv[j] << std::endl;
         continue;
         }
      pipe.start_msg();
      file >> pipe;
      pipe.end_msg();
      file.close();
      pipe.set_default_msg(j-1);
      std::cout << pipe << "  " << argv[j] << std::endl;
      }
   return 0;
   }
