/*************************************************
* DESX Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_DESX_H__
#define OPENCL_DESX_H__

#include <opencl/des.h>

namespace OpenCL {

class DESX : public BlockCipher
   {
   public:
      static std::string name() { return "DESX"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 24;
      BlockCipher* clone() const { return new DESX; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { des.clear(); K1.clear(); K2.clear(); }
      DESX() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<byte, BLOCKSIZE> K1, K2;
      DES des;
   };

}

#endif
