/*************************************************
* KDF1 Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_KDF1_H__
#define OPENCL_KDF1_H__

#include <opencl/pk_misc.h>

namespace OpenCL {

/*************************************************
* KDF1                                           *
*************************************************/
template<typename H>
class KDF1 : public KeyDerivationFunction
   {
   public:
      SecureVector<byte> derive(const byte[], u32bit) const;
      KDF1(const byte Parray[], u32bit n) { P.copy(Parray, n); }
      KDF1(const std::string& Pstr = "") { P.copy(Pstr.data(), Pstr.size()); }
   private:
      mutable H hash;
      SecureVector<byte> P;
   };

/*************************************************
* KDF1 Key Derivation Mechanism                  *
*************************************************/
template<typename H>
SecureVector<byte> KDF1<H>::derive(const byte in[], u32bit length) const
   {
   SecureVector<byte> r(H::HASHLENGTH);
   hash.update(in, length);
   hash.update(P, P.size());
   hash.final(r);
   return r;
   }

}

#endif
