/*************************************************
* MGF1 Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MGF1_H__
#define OPENCL_MGF1_H__

#include <opencl/pk_misc.h>

namespace OpenCL {

/*************************************************
* MGF1                                           *
*************************************************/
template<typename H>
class MGF1
   {
   public:
      static void mask(const byte[], u32bit, byte[], u32bit);
   private:
      static const u32bit HASHLENGTH = H::HASHLENGTH;
   };

/*************************************************
* MGF1 Mask Generation Function                  *
*************************************************/
template<typename H>
void MGF1<H>::mask(const byte in[], u32bit in_len, byte out[], u32bit out_len)
   {
   H hash;
   SecureBuffer<byte, 4> counter;
   SecureVector<byte> buffer(H::HASHLENGTH);
   while(out_len)
      {
      hash.update(in, in_len);
      hash.update(counter, 4);
      hash.final(buffer);

      u32bit xored = std::min(buffer.size(), out_len);
      xor_buf(out, buffer, xored);
      out += xored;
      out_len -= xored;

      for(s32bit j = 3; j >= 0; j--)
         if(++counter[j])
            break;
      }
   }

}

#endif
