/*************************************************
* MISTY1 Header File                             *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MISTY1_H__
#define OPENCL_MISTY1_H__

#include <opencl/opencl.h>

namespace OpenCL {

class MISTY1 : public BlockCipher
   {
   public:
      static std::string name() { return "MISTY1"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 16;
      BlockCipher* clone() const { return new MISTY1; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { EK.clear(); }
      MISTY1() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      static const byte S7[128], EK_ORDER[100], DK_ORDER[100];
      static const u16bit S9[512];
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void FL_E(u16bit&, u16bit&, u16bit&, u16bit&, u32bit) const;
      void FL_D(u16bit&, u16bit&, u16bit&, u16bit&, u32bit) const;
      void FO_E(u16bit,  u16bit,  u16bit&, u16bit&, u32bit) const;
      void FO_D(u16bit,  u16bit,  u16bit&, u16bit&, u32bit) const;
      static u16bit FI(u16bit, u16bit, u16bit);
      SecureBuffer<u16bit, 100> EK, DK;
   };

}

#endif
