/*************************************************
* Modular Reducer Header File                    *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MODARITH_H__
#define OPENCL_MODARITH_H__

#include <opencl/bigint.h>

namespace OpenCL {

class ModularReducer
   {
   public:
      virtual BigInt multiply(const BigInt&, const BigInt&) const;
      virtual BigInt reduce(const BigInt&) const = 0;
      ModularReducer(const BigInt&);
      virtual ~ModularReducer() {}
   protected:
      const BigInt modulus;
   };

ModularReducer* get_reducer(const BigInt&);

}

#endif
