/*************************************************
* Rijndael Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RIJNDAEL_H__
#define OPENCL_RIJNDAEL_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Rijndael : public BlockCipher
   {
   public:
      static std::string name() { return "Rijndael"; }
      static const u32bit BLOCKSIZE = 16, KEYLENGTH = 32;
      BlockCipher* clone() const { return new Rijndael; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw();
      Rijndael() : BlockCipher(name(), BLOCKSIZE, 16, 32, 8) {}
   public:
      static const byte SE[256], SD[256];
      static const u32bit TE0[256], TE1[256], TE2[256], TE3[256],
                          TD0[256], TD1[256], TD2[256], TD3[256];
      static u32bit S(u32bit);
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<u32bit, 52> EK, DK;
      SecureBuffer<byte, 32> ME, MD;
      u32bit rounds;
   };

typedef Rijndael AES;

}

#endif
