/*************************************************
* RIPEMD-160 Header File                         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RIPEMD_160_H__
#define OPENCL_RIPEMD_160_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RIPEMD_160 : public HashFunction
   {
   public:
      static std::string name() { return "RIPEMD-160"; }
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 20;
      void final(byte[HASHLENGTH]);
      void clear() throw();
      HashFunction* clone() const { return new RIPEMD_160; }
      RIPEMD_160() : HashFunction(name(), HASHLENGTH) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void hash(const byte[BLOCKSIZE]);
      static void F1(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F2(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F3(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F4(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F5(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 5> digest;
      u64bit count, position;
   };

// DEPRECATED ALIAS
typedef RIPEMD_160 RIPEMD160;

}

#endif
