/*************************************************
* Global RNG Header File                         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_GLOBAL_RNG_H__
#define OPENCL_GLOBAL_RNG_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* RNG Access Functions                           *
*************************************************/
namespace Global_RNG {

void randomize(byte[], u32bit);
byte random();

void add_entropy(const byte[], u32bit);
void add_entropy(EntropySource&, bool);

}

/*************************************************
* RNG Control Functions                          *
*************************************************/
void set_global_rng(RandomNumberGenerator*);

}

#endif
