/*************************************************
* XTEA Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_XTEA_H__
#define OPENCL_XTEA_H__

#include <opencl/opencl.h>

namespace OpenCL {

class XTEA : public BlockCipher
   {
   public:
      static std::string name() { return "XTEA"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 16;
      BlockCipher* clone() const { return new XTEA; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { EK.clear(); }
      XTEA() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      static const u32bit ROUNDS = 32;
      static const u32bit DELTAS[2*ROUNDS];
      static const byte KEY_INDEX[2*ROUNDS];
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<u32bit, 2*ROUNDS> EK;
   };

}

#endif
