/*************************************************
* Memory Locking Allocator Header File           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_MLOCK_ALLOCATOR_H__
#define OPENCL_EXT_MLOCK_ALLOCATOR_H__

#include <opencl/manalloc.h>
#include <opencl/mutex.h>
#include <vector>

namespace OpenCL {

/*************************************************
* Memory Locking Allocator                       *
*************************************************/
class MemoryLocking_Allocator : public ManagedAllocator
   {
   public:
      void* alloc_block(u32bit) const;
      void dealloc_block(void*, u32bit) const;
      SecureAllocator* clone() { return this; }
      MemoryLocking_Allocator(u32bit = 4, u32bit = 8192);
      ~MemoryLocking_Allocator();
   private:
      struct Buffer { void* buf; u32bit length; bool in_use; };
      u32bit check_size(u32bit) const;
      mutable std::vector<Buffer> allocated;
      mutable Mutex* lock;
   };

}

#endif
