/*************************************************
* Bzip Compressor Header File                    *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_BZIP2_H__
#define OPENCL_EXT_BZIP2_H__

#include <opencl/filter.h>

namespace OpenCL {

class Bzip_Compress : public Filter
   {
   public:
      void write(const byte input[], u32bit length);
      void start_msg();
      void end_msg();

      void flush();

      Bzip_Compress(u32bit l = 9) : level((l >= 9) ? 9 : l)
         { ready = false; bz = 0; }
      ~Bzip_Compress() { clear(); }
   private:
      static const u32bit BUFFERSIZE = DEFAULT_BUFFERSIZE;
      const u32bit level;
      void clear();
      SecureBuffer<byte, BUFFERSIZE> buffer;
      struct bz_stream_wrapper* bz;
      bool ready;
   };

class Bzip_Decompress : public Filter
   {
   public:
      void write(const byte input[], u32bit length);
      void start_msg();
      void end_msg();

      Bzip_Decompress(bool s = false) : small_mem(s)
         { no_writes = true; bz = 0;}
      ~Bzip_Decompress() { clear(); }
   private:
      static const u32bit BUFFERSIZE = DEFAULT_BUFFERSIZE;
      const bool small_mem;
      void clear();
      SecureBuffer<byte, BUFFERSIZE> buffer;
      struct bz_stream_wrapper* bz;
      bool no_writes;
   };

}

#endif
