/*************************************************
* EGD EntropySource Header File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_ENTROPY_SRC_EGD_H__
#define OPENCL_EXT_ENTROPY_SRC_EGD_H__

#include <opencl/opencl.h>

namespace OpenCL {

class EGD_EntropySource : public EntropySource
   {
   public:
      u32bit slow_poll(byte[], u32bit);
      u32bit fast_poll(byte buf[], u32bit len) { return slow_poll(buf, len); }

      EGD_EntropySource(const std::string& p) : path(p) {}
   private:
      const std::string path;
   };

}

#endif
