/*************************************************
* File Tree Walking EntropySource Header File    *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_ENTROPY_SRC_FTW__
#define OPENCL_EXT_ENTROPY_SRC_FTW__

#include <opencl/opencl.h>
#include <string>

namespace OpenCL {

class FTW_EntropySource : public EntropySource
   {
   public:
      u32bit fast_poll(byte[], u32bit);
      u32bit slow_poll(byte[], u32bit);

      FTW_EntropySource(const std::string& p) : path(p)
         { position = BUFFERSIZE; }
   private:
      void gather();
      void gather_from_dir(const std::string&);
      void gather_from_file(const std::string&);
      static const u32bit BUFFERSIZE = 1024;
      const std::string path;
      SecureBuffer<byte, BUFFERSIZE> buffer;
      u32bit position;
   };

}

#endif
