/*************************************************
* POSIX Thread Mutex Header File                 *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXT_MUTEX_PTHREAD_H__
#define OPENCL_EXT_MUTEX_PTHREAD_H__

#include <opencl/mutex.h>

namespace OpenCL {

/*************************************************
* Pthread Mutex                                  *
*************************************************/
class Pthread_Mutex : public Mutex
   {
   public:
      void lock();
      bool trylock();
      void unlock();
      Mutex* clone() const { return new Pthread_Mutex; }
      Pthread_Mutex();
      ~Pthread_Mutex();
   private:
      struct mutex_wrapper* mutex;
   };

}

#endif
