/*************************************************
* POSIX Timer Source File                        *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#define _POSIX_C_SOURCE 199506
#include <opencl/tm_posix.h>
#include <time.h>

namespace OpenCL {

/*************************************************
* Get the timestamp                              *
*************************************************/
u64bit POSIX_Timer::clock() const
   {
   struct timespec tv;
   clock_gettime(CLOCK_REALTIME, &tv);
   return tv.tv_nsec;
   }

}
