/*************************************************
* BigInt Stream I/O Source File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <iostream>
#include <opencl/bigint.h>

namespace OpenCL {

/*************************************************
* Write the BigInt into a stream                 *
*************************************************/
std::ostream& operator<<(std::ostream& stream, const BigInt& n)
   {
   Encoding code = Decimal;
   if(stream.flags() & std::ios::hex) code = Hexadecimal;

   if(stream.flags() & std::ios::oct)
      throw Invalid_Argument("BigInt: Octal output not supported");

   if(n.is_negative()) stream << '-';
   SecureVector<byte> buffer = encode(n, code);
   if(buffer.size() == 0)
      if(code == Hexadecimal) stream.write("00", 2);
      else                    stream.write("0", 1);
   else
      {
      u32bit skip = 0;
      while(buffer[skip] == '0' && skip < buffer.size())
         skip++;
      stream.write((char*)buffer.ptr() + skip, buffer.size() - skip);
      }
   if(!stream.good())
      throw Stream_IO_Error("BigInt output operator has failed");
   return stream;
   }

/*************************************************
* Read the BigInt from a stream                  *
*************************************************/
std::istream& operator>>(std::istream& stream, BigInt& n)
   {
   std::string str;
   std::getline(stream, str);
   if(stream.bad() || (stream.fail() && !stream.eof()))
      throw Stream_IO_Error("BigInt input operator has failed");
   n = BigInt(str);
   return stream;
   }

}
