/*************************************************
* Random BigInt Generation Source File           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/numthry.h>
#include <opencl/rng.h>
#include <vector>

namespace OpenCL {

/*************************************************
* Generate a random BigInt                       *
*************************************************/
BigInt random_integer(u32bit bits)
   {
   if(bits == 0) return BigInt::zero();
   SecureVector<byte> array((bits / 8) + ((bits % 8) ? 1 : 0));
   Global_RNG::randomize(array, array.size());
   if(bits % 8)
      array[0] &= 0xFF >> (8 - (bits % 8));
   array[0] |= 0x80 >> ((bits % 8) ? (8 - bits % 8) : 0);

   BigInt ret(array);
   return BigInt(array);
   }

/*************************************************
* Generate a random prime BigInt                 *
*************************************************/
BigInt random_prime(u32bit bits)
   {
   if(bits == 0 || bits == 1) return BigInt::zero();
   BigInt p;
   while(!is_prime(p))
      {
      p = random_integer(bits);
      p.set_bit(bits - 1);
      p.set_bit(bits - 2);
      p.set_bit(0);
      }
   return p;
   }

/*************************************************
* Generate a random safe prime                   *
*************************************************/
BigInt random_safe_prime(u32bit bits)
   {
   BigInt p;
   do
      p = (random_prime(bits - 1) << 1) + BigInt::one();
   while(!is_prime(p));
   return p;
   }

}
