/*************************************************
* Buffering Filter Source File                   *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/buf_filt.h>

namespace OpenCL {

/*************************************************
* BlockingFilter Constructor                    *
*************************************************/
BufferingFilter::BufferingFilter(u32bit b, u32bit i) : INITIAL_BLOCK_SIZE(i),
                                                       BLOCKSIZE(b)
   {
   initial_block_pos = block_pos = 0;
   initial.resize(i);
   block.resize(b);
   }

/*************************************************
* Reset the Blocking Filter                     *
*************************************************/
void BufferingFilter::end_msg()
   {
   if(initial_block_pos != INITIAL_BLOCK_SIZE)
      throw Exception("BufferingFilter: Not enough data for first block");
   final_block(block, block_pos);
   initial_block_pos = block_pos = 0;
   }

/*************************************************
* Block input                                   *
*************************************************/
void BufferingFilter::write(const byte in[], u32bit length)
   {
   if(initial_block_pos != INITIAL_BLOCK_SIZE)
      {
      u32bit copied = std::min(INITIAL_BLOCK_SIZE - initial_block_pos, length);
      initial.copy(initial_block_pos, in, copied);
      initial_block_pos += copied;
      in += copied;
      length -= copied;
      if(initial_block_pos == INITIAL_BLOCK_SIZE)
         initial_block(initial);
      }
   if(block_pos + length >= BLOCKSIZE)
      {
      main_block(block);
      in += (BLOCKSIZE - block_pos);
      length -= (BLOCKSIZE - block_pos);
      while(length >= BLOCKSIZE)
         {
         main_block(in);
         in += BLOCKSIZE;
         length -= BLOCKSIZE;
         }
      block.copy(in, length);
      block_pos = 0;
      }
   }

}
