/*************************************************
* Chain Source File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/chain.h>

namespace OpenCL {

/*************************************************
* Chain Constructor                              *
*************************************************/
Chain::Chain(Filter* f1, Filter* f2, Filter* f3, Filter* f4)
   {
   if(f1) { attach(f1); set_owns(owns() + 1); }
   if(f2) { attach(f2); set_owns(owns() + 1); }
   if(f3) { attach(f3); set_owns(owns() + 1); }
   if(f4) { attach(f4); set_owns(owns() + 1); }
   }

/*************************************************
* Chain Constructor                              *
*************************************************/
Chain::Chain(Filter* filters[], u32bit count)
   {
   for(u32bit j = 0; j != count; j++)
      if(filters[j])
         {
         attach(filters[j]);
         set_owns(owns() + 1);
         }
   }

}
