/*************************************************
* Default Allocator Source File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/defalloc.h>
#include <cstdlib>
#include <cstring>

namespace OpenCL {

/*************************************************
* Allocation                                     *
*************************************************/
void* Default_Allocator::alloc_block(u32bit n) const
   {
   if(n == PREF_SIZE)
      {
      for(u32bit j = 0; j != CACHE_SIZE; j++)
         if(cache[j])
            {
            void* x = cache[j];
            cache[j] = 0;
            return x;
            }
      }
   void* ptr = std::malloc(n);
   std::memset(ptr, 0, n);
   return ptr;
   }

/*************************************************
* Deallocation                                   *
*************************************************/
void Default_Allocator::dealloc_block(void* ptr, u32bit n) const
   {
   if(n == PREF_SIZE)
      {
      for(u32bit j = 0; j != CACHE_SIZE; j++)
         if(cache[j] == 0)
            {
            cache[j] = ptr;
            return;
            }
      }
   std::memset(ptr, 0, n);
   std::free(ptr);
   }

/*************************************************
* Constructor                                    *
*************************************************/
Default_Allocator::Default_Allocator() : ManagedAllocator(true, PREF_SIZE)
   {
   for(u32bit j = 0; j != CACHE_SIZE; j++)
      {
      cache[j] = std::malloc(PREF_SIZE);
      std::memset(cache[j], 0, PREF_SIZE);
      }
   }

/*************************************************
* Destructor                                     *
*************************************************/
Default_Allocator::~Default_Allocator()
   {
   for(u32bit j = 0; j != CACHE_SIZE; j++)
      if(cache[j])
         {
         std::memset(cache[j], 0, PREF_SIZE);
         std::free(cache[j]);
         }
   }

}
