/*************************************************
* DESX Source File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/desx.h>

namespace OpenCL {

/*************************************************
* DESX Encryption                                *
*************************************************/
void DESX::enc(const byte in[BLOCKSIZE], byte out[BLOCKSIZE]) const
   {
   xor_buf(out, in, K1, BLOCKSIZE);
   des.encrypt(out);
   xor_buf(out, K2, BLOCKSIZE);
   }

/*************************************************
* DESX Decryption                                *
*************************************************/
void DESX::dec(const byte in[BLOCKSIZE], byte out[BLOCKSIZE]) const
   {
   xor_buf(out, in, K2, BLOCKSIZE);
   des.decrypt(out);
   xor_buf(out, K1, BLOCKSIZE);
   }

/*************************************************
* DESX Key Schedule                              *
*************************************************/
void DESX::set_key(const byte key[], u32bit length) throw(Invalid_Key_Length)
   {
   if(!valid_keylength(length))
      throw Invalid_Key_Length(name(), length);
   K1.copy(key, BLOCKSIZE);
   des.set_key(key + BLOCKSIZE, BLOCKSIZE);
   K2.copy(key + 2 * BLOCKSIZE, BLOCKSIZE);
   }

}

