/*************************************************
* File EntropySource Source File                 *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/es_file.h>
#include <fstream>

namespace OpenCL {

/*************************************************
* Gather Entropy from Randomness Source          *
*************************************************/
u32bit File_EntropySource::slow_poll(byte output[], u32bit length)
   {
   u32bit read = 0;
   for(u32bit j = 0; j != sources.size(); j++)
      {
      std::ifstream random_source(sources[j].c_str());
      if(!random_source) continue;
      random_source.read((char*)output + read, length);
      read += random_source.gcount();
      length -= random_source.gcount();
      if(length == 0) break;
      }
   return read;
   }

/*************************************************
* File_EntropySource Constructor                 *
*************************************************/
File_EntropySource::File_EntropySource(bool add_defaults)
   {
   if(add_defaults)
      {
      sources.push_back("/dev/urandom");
      sources.push_back("/dev/random");
      }
   }

/*************************************************
* File_EntropySource Constructor                 *
*************************************************/
File_EntropySource::File_EntropySource(const std::string& dev)
   {
   sources.push_back(dev);
   }

}
