/*************************************************
* Modular Reducer Source File                    *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/reducer.h>
#include <opencl/barrett.h>

namespace OpenCL {

/*************************************************
* Construct a ModularReducer                     *
*************************************************/
ModularReducer::ModularReducer(const BigInt& n) : modulus(n)
   {
   if(modulus.is_zero() || modulus.is_negative())
      throw Invalid_Argument("ModularReducer: modulus must be positive");
   }

/*************************************************
* Modular Multiplication                         *
*************************************************/
BigInt ModularReducer::multiply(const BigInt& a, const BigInt& b) const
   {
   return reduce(a * b);
   }

/*************************************************
* Get a modular reducer for n                    *
*************************************************/
ModularReducer* get_reducer(const BigInt& n)
   {
   return new BarrettReducer(n);
   }

}
