/*************************************************
* S2K Base Class Source File                     *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/s2k.h>
#include <opencl/rng.h>

namespace OpenCL {

/*************************************************
* Set the number of iterations                   *
*************************************************/
void S2K::set_iterations(u32bit i)
   {
   if(can_change_iterations())
      iter = i;
   else
      throw Exception("S2K: Iteration count cannot be set by this S2K method");
   }

/*************************************************
* Change the salt                                *
*************************************************/
void S2K::change_salt(const byte new_salt[], u32bit length)
   {
   salt.create(length);
   salt.copy(new_salt, length);
   }

/*************************************************
* Change the salt                                *
*************************************************/
void S2K::change_salt(const SecureVector<byte>& new_salt)
   {
   change_salt(new_salt.ptr(), new_salt.size());
   }

/*************************************************
* Change the salt                                *
*************************************************/
void S2K::change_salt(u32bit length)
   {
   salt.create(length);
   Global_RNG::randomize(salt, length);
   }

}
