/*************************************************
* Secure Memory Allocator Source File            *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#include <opencl/secalloc.h>

namespace OpenCL {

/*************************************************
* Allocation                                     *
*************************************************/
void* SecureAllocator::allocate(u32bit n) const
   {
   if(n == 0) return 0;
   void* ptr = alloc_block(n);
   if(!ptr) throw Memory_Exhaustion();
   return ptr;
   }

/*************************************************
* Deallocation                                   *
*************************************************/
void SecureAllocator::deallocate(void* ptr, u32bit n) const
   {
   if(ptr == 0 || n == 0) return;
   dealloc_block(ptr, n);
   }

}
