#!/bin/sh
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

ORIGDIR=`pwd`
cd $srcdir
PROJECT=openvpn
TEST_TYPE=-f
FILE=openvpn.c

DIE=0

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have autoconf installed to compile $PROJECT."
	echo "Download the appropriate package for your distribution,"
	echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have automake installed to compile $PROJECT."
	echo "Download the appropriate package for your distribution,"
	echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

if test "$DIE" -eq 1; then
	exit 1
fi

test $TEST_TYPE $FILE || {
	echo "You must run this script in the top-level $PROJECT directory"
	exit 1
}

# Let's have a fresh start
rm -f *.o openvpn config.cache configure Makefile Makefile.in stamp-h* config.log config.status config.h config.h.in aclocal.m4

aclocal $ACLOCAL_FLAGS || exit 1

#libtoolize --force --copy || exit 1
autoheader || exit 1
automake --add-missing --copy $am_opt || exit 1
autoconf || exit 1
cd $ORIGDIR || exit 1

echo 
echo "Now type './configure' and 'make' to compile $PROJECT. You can do this" 
echo "in a separate build directory if you wish."
