Name:           openvrml
Version:        0.12.3
Release:        1
Summary:        VRML97 runtime library. 
Copyright:      LGPL
Group:          System Environment/Libraries
Packager:       The OpenVRML Development Team <openvrml-develop@lists.sf.net>
Source:         http://prdownloads.sf.net/openvrml/%{name}-%{version}.tar.gz
URL:            http://openvrml.org
BuildRequires:  zlib-devel libpng-devel libjpeg-devel mozilla-devel XFree86-devel glut-devel
BuildRoot:      %{_tmppath}/%{name}-root
Requires:       zlib >= 1.1.3
Requires:       libpng >= 1.0.12
Requires:       libjpeg >= 6b
Requires:       mozilla = 1.0.0
Prefix:         /usr

%description 
OpenVRML is a VRML support library, including a runtime and facilities for
reading and writing VRML models.


%package devel
Summary:        Headers and static library for developing C++ programs with OpenVRML
Group:          Development/Libraries
Requires:	%{name}
%description devel
Headers and static library that programmers will need to develop C++ programs
using OpenVRML

%package gl
Summary:        OpenGL renderer for OpenVRML
Group:          System Environment/Libraries
Requires:       %{name} = %{version}
Requires:       XFree86 >= 4.2
Requires:       glut >= 3.7
%description gl
OpenGL renderer for OpenVRML.

%package gl-devel
Summary:        OpenVRML OpenGL renderer headers and static library.
Group:          Development/Libraries
Requires:       %{name}-gl = %{version}
Requires:       XFree86-devel >= 4.2
Requires:       glut-devel >= 3.7
%description gl-devel
Headers and static library that programmers will need to develop C++ programs
using the OpenVRML OpenGL renderer.

%package -n lookat
Summary:        VRML viewer
Group:          Applications/Multimedia
Requires:       %{name}-gl = %{version}
%description -n lookat
GLUT-based VRML viewer.


%prep
%setup


%build
./configure $ARCH_FLAGS --prefix=%{prefix} --without-jdk --without-doxygen CPPFLAGS="-I/usr/include/mozilla-1.0.0/js" CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-L/usr/lib/mozilla-1.0.0"
make


%install
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi
make prefix=$RPM_BUILD_ROOT%{prefix} install


%files 
%doc AUTHORS COPYING COPYING.LIB ChangeLog NEWS README THANKS
%{prefix}/lib/libopenvrml.so.*
%{prefix}/lib/pkgconfig/openvrml.pc

%files devel
%{prefix}/include/OpenVRML
%{prefix}/lib/libopenvrml.la
%{prefix}/lib/libopenvrml.a
%{prefix}/lib/libopenvrml.so

%files gl
%{prefix}/lib/libopenvrml-gl.so.*
%{prefix}/lib/pkgconfig/openvrml-gl.pc

%files gl-devel
%{prefix}/include/OpenVRML/GL
%{prefix}/lib/libopenvrml-gl.la
%{prefix}/lib/libopenvrml-gl.a
%{prefix}/lib/libopenvrml-gl.so

%files -n lookat
%{prefix}/bin/lookat
%{prefix}/share/pixmaps/lookat.xpm


%changelog
* Sun Jun 30 2002  Braden McDaniel  <braden@endoframe.com>
- configure --without-doxygen.
- Removed "doc/conformance.html" from %doc.

* Sat Jun 15 2002  Braden McDaniel  <braden@endoframe.com>
- Use CPPFLAGS and LDFLAGS for Mozilla 1.0.0 when running configure.
- Require Mozilla 1.0.0.

* Mon May 20 2002  Braden McDaniel  <braden@endoframe.com>
- Fixed pkgconfig metafile names.
- Updated dependencies to reflect RPMs shipping with Red Hat 7.3.
- Updated source download URI.
- Removed prefix.
- Added BuildRequires.
- Added Requires for zlib, libpng, libjpeg, mozilla.
- configure --without-jdk.

* Thu Jan 24 2002  Braden McDaniel  <braden@endoframe.com>
- Added package metafiles for pkgconfig.
- Removed autoconf macros for use by client packages.

* Fri Jun 29 2001  Braden McDaniel  <braden@endoframe.com>
- Removed MPL-1.1.txt from %doc. File nolonger distributed.
- Prefer the shorter "sf.net" to "sourceforge.net".

* Wed Jun 6 2001  Braden McDaniel  <braden@endoframe.com>
- Added COPYING to %doc.
- Changed URL to <http://openvrml.org>
- Corrected packager e-mail address.

* Thu Jan 25 2001  Braden McDaniel  <braden@endoframe.com>
- Fixed location of lookat icon in %files section for lookat
- Added Mesa >= 3.2 as a requirement for openvrml-gl.

* Tue Jan 2 2001  Braden McDaniel  <braden@endoframe.com>
- Removed obsolete TODO from %doc.

* Sun Dec 31 2000  Clayton Cottingham <drfrog@smartt.com>
- Change in install section rm command is now recursive 

* Fri Dec 15 2000  Braden McDaniel  <braden@endoframe.com>
- Added lookat.xpm to files section for lookat.

* Fri Dec 8 2000  Braden McDaniel  <braden@endoframe.com>
- Changes to reflect library name and header location changes.

* Sun Dec 3 2000  Braden McDaniel  <braden@endoframe.com>
- Removed README.SOUND from %doc

* Sun Nov 26 2000  Braden McDaniel  <braden@endoframe.com>
- Added conformance.html to %doc.
- Removed obsolete COPYING.ANTLR from %doc.
- Changed URL to <http://openvrml.sourceforge.net>.
- Removed obsolete NODES from %doc.

* Thu Nov 23 2000  Braden McDaniel  <braden@endoframe.com>
- Gave much love. Checked into CVS. Still not guaranteed to work, though.

* Tue Oct 24 2000  Braden McDaniel  <braden@endoframe.com>
- Received initial spec file from Clayton Cottingham <drfrog@smartt.com>.
