%define name	pan
%define version 0.11.2
%define release 1

Summary:   The Pan Newsreader
Name:      %{name}
Version:   %{version}
Release:   %{release}
Copyright: GPL
Group:     Applications/Internet
URL:       http://pan.rebelbase.com/
Source:    http://pan.rebelbase.com/download/%{version}/%{name}-%{version}.tar.bz2
Packager:  Charles Kerr <charles@rebelbase.com>
Vendor:    ChimPanXi
Epoch:     1

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: gtk+-devel >= 1.2.10
BuildRequires: glib-devel >= 1.2.8
BuildRequires: gnome-libs-devel >= 1.0.16
BuildRequires: libxml-devel >= 1.8.11
BuildRequires: gdk-pixbuf-devel >= 0.10.1
BuildRequires: gettext >= 0.10.35

Requires: gtk+ >= 1.2.10
Requires: glib >= 1.2.8
Requires: gnome-libs >= 1.0.16
Requires: libxml >= 1.8.11
Requires: gdk-pixbuf >= 0.10.1

Provides: %{name}

%description
Pan is a newsreader, loosely based on Agent and Gravity, which attempts
to be pleasant to use for new and advanced users alike. It has all the
typical features found in newsreaders and also supports offline newsreading,
sophisticated filtering, multiple connections, and a number of extra features
for power users and alt.binaries fans.  It's also the only Unix newsreader
to get a perfect score on the Good Net-Keeping Seal of Approval evalutions.
See http://pan.rebelbase.com/features.html for the whole sales pitch.

%prep
rm -rf $RPM_BUILD_ROOT
%setup
cp /usr/share/gettext/po/Makefile.in.in po
%build
%configure
make CFLAGS="$RPM_OPT_FLAGS" LDFLAGS=-s
%install
make DESTDIR=$RPM_BUILD_ROOT install
%find_lang %{name}
%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING CREDITS ChangeLog README TODO NEWS INSTALL ANNOUNCE
%attr(755,root,root) %{_bindir}/%{name}
%{_datadir}/gnome/apps/Internet/%{name}.desktop
%{_datadir}/pixmaps/*


%changelog

* Sat Sep 22 2001 Charles Kerr <charles@rebelbase.com>
- Added gdk-pixbuf and -devel to Requires and BuildRequires
- Updated gtk/glib and -devel requirements

* Sat Aug 18 2001 Christophe Lambin <clambin@easynet.be>
- fixes for RH 7.1 + Ximian Gnome 1.4
- allow single tarball to be used for both pan & pan-images
- use gettext 0.10.35's Makefile.in.in for po since it gives us DESTDIR

* Thu Aug 9 2001 Charles Kerr <charles@rebelbase.com>
- removed some dependencies that are better left implicit

* Mon Apr 23 2001 Charles Kerr <charles@rebelbase.com>
- merged in improvements from rh, mdk, and polish versions of pan.spec

* Sun Jun 25 2000 Charles Kerr <charles@rebelbase.com>
- added Vendor
- updated the description to match the README desc & FAQ

* Mon Jan 24 2000 Simon Piette
- changed the build section to allow building RPMS on non-x86 archs

* Sun Dec 12 1999 Jason Leach <leach@wam.umd.edu>
- changed the Summary string
- updated the description to match the README desc

* Wed Dec 1 1999 Charles Kerr <charles@rebelbase.com>
- added "-ggdb3" to CFLAGS so that it'll be easier to read backtraces
  submitted in bug reports

* Thu Nov 4 1999 Jason Leach <leach@wam.umd.edu>
- added gtk+-1.2.6 requirement (1.2.3 definitely breaks, might as well
  make it newest gtk+)

* Tue Nov 2 1999 Jason Leach <leach@wam.umd.edu>
- made .spec.in file to auto-generate .spec

* Sat Sep 25 1999 Leland Elie <lelie@airmail.net>
- created spec file.
