/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@rebelbase.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_ACTIONS_H__
#define __ARTICLE_ACTIONS_H__

#include <pan/base/article.h>
#include <pan/base/group.h>

void      article_cancel                             (Article         * article);

void      article_supersede                          (const Article   * article);

gboolean  article_copy_articles_to_folder            (Group           * folder,
                                                      Article        ** articles,
                                                      gint              qty);

void      article_action_selected_save_attachments   (void);

void      article_action_selected_open_attachments   (void);

void      article_action_selected_save               (void);

void      article_action_selected_save_as            (void);

void      article_action_delete_selected_articles    (void);

void      article_action_delete_selected_threads     (void);

void      article_action_edit_selected               (void);

#endif
