
/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef RUN_H
#define RUN_H

#include <glib.h>

/**
 * A run is just a substring from a larger memory chunk.
 * Runs don't own the memory they have; they just index into the chunk.
 * You can use runs to extract temporary strings without heap overhead.
 */
typedef struct
{
	const gchar * str;
	guint len;
}
Run;

/**
***  Run operations
**/

#define run_init(r,instr,inlen) ((r)->str=instr,(r)->len=inlen,(r))

#define run_clear(r) ((r)->str=NULL,(r)->len=0,(r))

gchar*        run_strdup         (const Run     * run);

Run*          run_strstrip       (Run           * run);

const gchar*  run_strchr         (const Run     * run,
                                  gchar           ch);

gint          run_runcmp         (const Run     * r1,
                                  const Run     * r2);

gint          run_strcmp         (const Run     * r1,
                                  const gchar   * str);

/**
***  For hashtables of runs
**/

gint        run_equal          (gconstpointer   v,
	                        gconstpointer   v2);

guint       run_hash           (gconstpointer   v);

#endif
