/*
 * Pan - A Newsreader for X
 * Copyright (C) 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <libgnomeui/libgnomeui.h>

#include <pan/base/pan-i18n.h>

#include <pan/message-check-ui.h>
#include <pan/util.h>

void
check_article_and_prompt (const Article    * article,
                          Server           * server,
                          GPtrArray        * appendme_errors,
                          GoodnessLevel    * setme_goodness)
{
	check_article (article, server, appendme_errors, setme_goodness);

	/* post the warnings, if we have any */
	if (appendme_errors->len != 0)
	{
		guint i;
		GString * str;

		/* build the error message */
		str = g_string_new (NULL);
		for (i=0; i!=appendme_errors->len; ++i) {
			char * e = (char*)g_ptr_array_index(appendme_errors,i);
			g_string_append (str, e);
			g_string_append_c (str, '\n');
		}
		g_warning (str->str);

		/* either refuse, or ask the user if they're sure. */
		if (*setme_goodness==REFUSE)
		{
			pan_error_dialog (str->str);
		}
		else
		{
			guint button;
			const gchar *ques = appendme_errors->len > 1
				? _("Post anyway, despite these problems?")
				: _("Post anyway, despite this problem?");
			g_string_append (str, "\n");
			g_string_append (str, ques);
			button = gnome_dialog_run_and_close (GNOME_DIALOG(
					gnome_message_box_new (str->str,
						GNOME_MESSAGE_BOX_QUESTION,
						GNOME_STOCK_BUTTON_YES,
						GNOME_STOCK_BUTTON_NO,
						NULL)));
			if (button==0) /* yes, post anyway */
				*setme_goodness = OKAY;
		}

		/* cleanup */
		g_string_free (str, TRUE);
	}
}
